/*
 * Copyright:
 *
 * 	Copyright (c) 2010 by Timothy Wagner. All Rights Reserved.
 *
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

int uriQuery2env(const char *query, const char *envPrefix)
	{
	char	*buffer;
	char	*decode;
	char	*name;
	char	*value;
	char	*envName;
	char	ch;
	char	code;
	int	count = 0;
	int	hexDigit = 0;

	buffer = malloc(strlen(query) + 1);
	name = value = decode = buffer;
	for (ch = *query; ch; query++, ch = *query)
		{
		if (hexDigit)
			{
			code = (code << 4) | ((ch >> 6) * 9 + (ch & 0x0F));
			if (--hexDigit == 0)
				{
				*decode = code & 0x7F;
				decode++;
				}
			}
		else if (ch == '%')
			{
			hexDigit = 2;
			code = 0;
			}
		else if (ch == '+')
			{
			*decode = ' ';
			decode++;
			}
		else if (ch == '=')
			{
			*decode = '\0';
			decode++;
			value = decode;
			}
		else if (name == value)
			{
			*decode = toupper(ch);
			decode++;
			}
		else if (ch != '&')
			{
			*decode = ch;
			decode++;
			}

		if (ch == '&' || *(query + 1) == '\0')
			{
			*decode = '\0';
			envName = (char *)
				malloc(strlen(envPrefix) + strlen(name) + 1);
			strcpy(envName, envPrefix);
			strcat(envName, name);
			setenv(envName, value, 0);
			free(envName);
			name = value = decode = buffer;
			count++;
			}
		}
	free(buffer);
	return count;
	}
