/*
 * Super Simple Serial
 *
 * Copyright:
 *
 * 	Copyright (c) 2010 by Timothy Wagner. All Rights Reserved.
 *
 */

#include <termios.h>
#include <stdio.h>

/*
 * Available Baud Rates
 *
 *	B50	50 baud
 *	B75	75 baud
 *	B110	110 baud
 *	B134	134.5 baud
 *	B150	150 baud
 *	B200	200 baud
 *	B300	300 baud
 *	B600	600 baud
 *	B1200	1200 baud
 *	B1800	1800 baud
 *	B2400	2400 baud
 *	B4800	4800 baud
 *	B9600	9600 baud
 *	B19200	19200 baud
 *	B38400	38400 baud
 *	B57600	57,600 baud
 *	B76800	76,800 baud
 *	B115200	115,200 baud
 */

/*
 * Available Data Bits
 *
 *	CS5	5 data bits
 *	CS6	6 data bits
 *	CS7	7 data bits
 *	CS8	8 data bits
 */

/*
 * Available Stop Bits
 */
#define STOP_BITS_1	1
#define STOP_BITS_2	2

/*
 * Available Parity Options
 */
#define	PARITY_NONE	0
#define	PARITY_ODD	1
#define PARITY_EVEN	2

extern int serial_open(char *device);

extern int serial_close(int fd);

extern int serial_setup(int fd, int baud_rate,
	int data_bits, int stop_bits, int parity);

extern char *serial_read_to_malloc(int fd_serial, unsigned long *read_size,
	long request_size);

extern unsigned long serial_read_to_file(int fd_serial, FILE *fd_out,
	long request_size);

extern int serial_write(int fd_serial, void *buffer, int count);

extern long serial_elapsed_microsecs();
